#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//infinite cubesMod01.fsh  by  calimops
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0666  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define M_PI 3.1415926

// SETTINGS
const float zFar = 50.;
const float zNear = 1.;

const vec3 background_color = vec3(0.7);
const float collision_distance = 0.001;
const int marching_iterations = 64;

const float normal_partial_derivative_epsilon = 0.00001;

// COLORS
const vec3 red   = vec3(1., 0., 0.);
const vec3 green = vec3(0., 1., 0.);
const vec3 blue  = vec3(0.8);

float sq(in float n) {
    return n * n;
}

// Transformations
mat4 worldMatrix = mat4(1., 0., 0., 0.,   0., 1., 0., 0.,   0., 0., 1., 0.,   0., 0., 0., 1.);

void identity() {
    worldMatrix = mat4(1., 0., 0., 0.,   0., 1., 0., 0.,   0., 0., 1., 0.,   0., 0., 0., 1.);
}

void scale(in float a, in float b, in float c) {
    worldMatrix *= mat4(a , 0., 0., 0.,
                        0., b , 0., 0.,
                        0., 0., c , 0.,
                        0., 0., 0., 1.);
}

void trans(in vec3 v) {
    worldMatrix *= mat4(1., 0., 0., v.x,
                        0., 1., 0., v.y,
                        0., 0., 1., v.z,
                        0., 0., 0., 1.);
}


const float factor = 0.001;

float sdBoundingBox( vec3 p, vec3 b, float e )
{
//      p = vec3(p.x*cos(iTime*factor) - p.y*sin(iTime*factor), p.x*sin(iTime*factor) + p.y*cos(iTime*factor), p.z);
      p = abs(p)-b;
      vec3 q = abs(p+e)-e;
      return min(min(
      length(max(vec3(p.x,q.y,q.z),0.0))+min(max(p.x,max(q.y,q.z)),0.0),
      length(max(vec3(q.x,p.y,q.z),0.0))+min(max(q.x,max(p.y,q.z)),0.0)),
      length(max(vec3(q.x,q.y,p.z),0.0))+min(max(q.x,max(q.y,p.z)),0.0));
}

vec4 scene(vec3 pos) {
    pos = (vec4(pos, 1.) * worldMatrix).xyz;
    pos = mod(pos, 10.)-5.0;
    return vec4(blue, sdBoundingBox(pos, vec3(3.0), 0.3)); 
}

vec3 calcNormal( in vec3 p ) {
    const float h = 0.001;
    const vec2 k = vec2(1, -1);
    return normalize( k.xyy * scene( p + k.xyy * h ).a + 
                      k.yyx * scene( p + k.yyx * h ).a + 
                      k.yxy * scene( p + k.yxy * h ).a + 
                      k.xxx * scene( p + k.xxx * h ).a );
}

vec4 ray_marching(vec3 pos, vec3 dir) {
    dir = normalize(dir);
    float len = 0.;
    float mindist;
    vec3 color;
    vec3 norm;

    for (int i = 0; i < marching_iterations; ++i) {
    
//        pos = vec3(pos.x*cos(len*factor) - pos.y*sin(len*factor), pos.x*sin(len*factor) + pos.y*cos(len*factor), pos.z);

        vec4 tmp = scene(pos);
        
        color = tmp.rgb;
        mindist = tmp.a;
        norm = calcNormal(pos);
        len += mindist;
        
        //pos = vec3(pos.x*cos(len*factor) - pos.y*sin(len*factor), pos.x*sin(len*factor) + pos.y*cos(len*factor), pos.z);

        if (mindist < collision_distance) 
        {
            return vec4(color * max(0.4, dot(normalize(vec3(0.) - pos), norm)), len);
        }
        
        if (len > zFar) 
        {
            return vec4(background_color, len);
        }

        //len += mindist;
        pos += dir * mindist;
    }
    return vec4(background_color, len);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy / vec2(min(iResolution.x, iResolution.y));
    uv -= (iResolution.xy / min(iResolution.x, iResolution.y) - vec2(1.)) / 2.;
    //uv.y = 1. - uv.y;
    
    float aberrationAmount = 0.1;
    vec2 distFromCenter = uv - 0.5;
    
    vec2 aberrated = aberrationAmount * pow(distFromCenter, vec2(3.0, 3.0));
    

    identity();
    trans(vec3(5, 5, 10.*iTime));
    //rotx(iTime/10.0 + 2.);
    //rotz(iTime/10.0 + 2.);
    //roty(iTime/10.0 + 2.);
    
    vec4 rayMar1 = ray_marching(vec3(0.), vec3(uv - vec2(0.5)-aberrated, zNear));
    vec4 rayMar2 = ray_marching(vec3(0.), vec3(uv - vec2(0.5), zNear));
    vec4 rayMar3 = ray_marching(vec3(0.), vec3(uv - vec2(0.5)+aberrated, zNear));
    
    vec3 color = (exp(-0.06 * rayMar2.a)) * vec3(rayMar1.r, rayMar2.g, rayMar3.b);

    fragColor = vec4(color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

